#!/usr/bin/perl
#
# Copyright 2006 Righteous Software Inc.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

use warnings;
use strict;

use FindBin;
use lib "$FindBin::RealBin/";
use BuagentAuth;
my $DOMAINMAP = "/etc/virtualhosting/mappings/domainmap";

open(my $dm, '<', $DOMAINMAP);
while(<$dm>) {
	chomp;
	my $domain;
	my $site;
	if(/^([^\s]*)\s*=\s*(.*)$/) {
		$domain = $1;
		$site = $2;
	} else {
		next;
	}
	next if !defined($domain);
	next if !defined($site);
	my $fst = "/home/virtual/$site/fst";
	
	my $owner;
	my $sub = "/etc/virtualhosting/subdomain/$site";
	open(my $sfile, '<', $sub);
	while(<$sfile>) {
		chomp;
		if(/^owner\s*=\s*(.*)$/) {
			$owner = $1
		}
	}
	close($sfile);
	next if !defined($owner);

	my $user = $owner . "@" . $domain;
	print "$user:domain file system:$fst\n";
}
close($dm);
