#!/bin/sh
##############################################################################
#                                                                            #
# Copyright (c) 2005 by Righteous Software All rights reserved               #
#                                                                            #
##############################################################################

export PATH=/sbin:/usr/sbin:${PATH} 

echo -n "-- making tmp directory "
TMP=`mktemp -d /tmp/r1soft-report-XXXXXX`
echo "done."

echo "============================================"
echo "using: ${TMP}" 

echo -n "-- getting '/var/log/messages' " 
cat /var/log/messages 2>${TMP}/messages.error | gzip -9 >  ${TMP}/messages.gz
echo "done." 

echo -n "-- getting '/proc/partitions' "
cat /proc/partitions > ${TMP}/partitions 2>&1
echo "done. "

echo -n "-- getting 'fdisk -l' "
fdisk -l > ${TMP}/fdisk 2>&1
echo "done." 

echo -n "-- getting 'cdp -v' "
/usr/sbin/r1soft/bin/cdp -v > ${TMP}/cdp 2>&1
echo "done." 

echo -n "-- getting 'ls -la /lib/modules/r1soft' "
ls -la /lib/modules/r1soft > ${TMP}/modules 2>&1
echo "done."

echo -n "-- getting 'date' "
date > ${TMP}/date 2>&1
echo "done."

echo -n "-- getting 'uname -a' "
uname -a > ${TMP}/uname 2>&1
echo "done." 

echo -n "-- getting 'ls -la /dev' "
ls -la /dev > ${TMP}/dev 2>&1
echo "done."

echo -n "-- getting 'lsmod' "
lsmod > ${TMP}/lsmod 2>&1
echo "done." 

echo -n "-- getting 'ifconfig -a' "
ifconfig -a > ${TMP}/ifconfig 2>&1
echo "done."

echo -n "-- getting 'route -n' "
route -n > ${TMP}/route 2>&1
echo "done." 

echo -n "-- getting 'netstat -anp' "
netstat -anp > ${TMP}/netstat 2>&1
echo "done."

echo -n "-- getting 'ps -auxf' "
ps auxf > ${TMP}/ps 2>&1
echo "done."

echo -n "-- getting 'w' "
w > ${TMP}/w 2>&1
echo "done."

echo -n "-- getting 'cat /proc/mounts' "
cat /proc/mounts > ${TMP}/mounts 2>&1
echo "done."

echo -n "-- getting 'df' "
df > ${TMP}/df 2>&1
echo "done."

echo -n "-- getting 'dmesg' "
dmesg > ${TMP}/dmesg 2>&1
echo "done."

echo -n "-- getting 'cat /proc/version' "
cat /proc/version > ${TMP}/version 2>&1
echo "done."

echo -n "-- getting 'cat /proc/meminfo' "
cat /proc/meminfo > ${TMP}/meminfo 2>&1
echo "done."

echo -n "-- getting 'cat /proc/cpuinfo' "
cat /proc/cpuinfo > ${TMP}/cpuinfo 2>&1
echo "done."

echo -n "-- getting 'cat /proc/slabinfo' "
cat /proc/slabinfo > ${TMP}/slabinfo 2>&1
echo "done."

echo -n "-- getting '/usr/sbin/r1soft/log/cdp.log' " 
cat /usr/sbin/r1soft/log/cdp.log 2>${TMP}/cdplog.error | gzip -9 > ${TMP}/cdp.log.gz 
echo "done." 

echo -n "-- making tar file "
tar czfh "${TMP}.tar.gz" "${TMP}"

echo "============================================"
echo "Please email this file to support@r1soft.com" 
echo
echo "file: ${TMP}.tar.gz"
echo
echo "============================================"
