#!/usr/bin/perl
#
# Copyright 2011 Idera, Inc.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package BuagentAuth;

use warnings;
use strict;

sub auth {
	my $user = shift;
	my $pass = shift;
	my $passwdfile = shift || '/etc/passwd';
	my $shadowfile = shift || '/etc/shadow';

	my $auth_ok = 0;

	if (!defined($user) || $user eq "" || !defined($pass) || $pass eq "") { goto finish; }

	my $homedir;
	my $uid;
	my $gid;

	my $passwd;
	open($passwd, '<', $passwdfile) || goto finish;
	while(<$passwd>) {
		my @fields = split /:/;
		if ($fields[0] eq $user) {
			$homedir = $fields[5];
			$uid = $fields[2];
			$gid = $fields[3];
			last;
		}
	}
	close($passwd);

	my $shadow;
	my $cryptpass;
	open($shadow, '<', $shadowfile) || goto finish;
	while(<$shadow>) {
		my @fields = split /:/;
		if ($fields[0] eq $user) {
			$cryptpass = $fields[1];
			last;
		}
	}
	close($shadow);

	if (defined ($cryptpass) && $cryptpass ne "" && crypt($pass, $cryptpass) eq $cryptpass) {
		$auth_ok = 1;
	}

	if (!defined($homedir) || $homedir eq "" || !defined($uid) || $uid !~ /^\d+$/ || !defined($gid) || $gid !~ /^\d+$/) {
		$auth_ok = 0;
	}

finish:

	my %result;
	$result{auth_ok} = $auth_ok;
	if ($auth_ok == 1) {
		$result{uid}=$uid;
		$result{gid}=$gid;
		$result{homedir}=$homedir;
	}
	return \%result;
}

1;
