#!/bin/bash
#
# Copyright 2011 Idera, Inc.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

VZPKGLIB=${VZPKGLIB:-/usr/share/vzpkgtools/vzpkglib}
if [ ! -f $VZPKGLIB ]; then
        echo "ERROR: Could not find $VZPKGLIB"
        exit 1
fi
. $VZPKGLIB

read_vz_globals
for VEID in `vzlist -a -H -o ctid`; do
	if [ $VEID -eq 1 ]; then
		continue
	fi
	read_ve_config $VEID
	if [ -d "$VE_PRIVATE/fs/root/etc" ]; then
		echo "$VEID:veprivatefsroot:$VE_PRIVATE/fs/root"
	elif [ -d "$VE_PRIVATE/fs/etc" ]; then
		echo "$VEID:veprivatefsroot:$VE_PRIVATE/fs"
	elif [ -d "$VE_PRIVATE/etc" ]; then
		echo "$VEID:veprivatefsroot:$VE_PRIVATE/"
	elif [ -d "$VE_ROOT/etc" ]; then
		echo "$VEID:veprivatefsroot:$VE_ROOT/"
	fi
done
