<table class="data-table backups-list"  width="100%" cellspacing=0>
    <thead>
        <tr>
            <td>{$lang.date}</td>
            <td>{$lang.Disk}</td>
            <td>{$lang.status}</td>
            <td>{$lang.size}</td>
            <td>{$lang.type}</td>
            <td>&nbsp;</td> <td>&nbsp;</td>
        </tr>
    </thead>
    {foreach item=backup from=$backups}
    <tr>
        <td>{$backup->_created_at|regex_replace:"/[TZ]/":' '}</td>
        <td>#{$backup->_disk_id}</td>
        <td>
            {if $backup->_is_deleted}
                Scheduled for removal
            {elseif $backup->_built == "true" }
            {$lang.Built}
            {else}
            {$lang.Pending}
            {/if}
        </td>
        <td>
            {if $backup->_built != "true"}
            {$lang.notbuilt}
            {elseif $backup->_backup_size gt 1024}
            { $backup->_backup_size/1024|round } MB
            {else}
            {$backup->_backup_size} K
            {/if}
        </td>
        <td>
            {if $backup->_built != "true"}
            &nbsp;
            {else}
            { $backup->_backup_type }
            {/if}
        </td>
        <td>
            {if $backup->_built != "true"}
            &nbsp;
            {else}
            <a href="?cmd=clientarea&action=services&service={$service.id}&vpsdo=backups&vpsid={$vpsid}&do=restore&backupid={$backup->_id}&security_token={$security_token}" onclick="return confirm('{$lang.suretorestorebkp}');" class="small_control small_backup_restore fs11">{$lang.restore}</a>
            {/if}
        </td>
        <td width="60" style="text-align: right">
            <a href="?cmd=clientarea&action=services&service={$service.id}&vpsid={$vpsid}&vpsdo=backups&do=delete&backupid={$backup->_id}&security_token={$security_token}" onclick="return confirm('{$lang.suretodeletebkp}')" class="small_control small_delete fs11">{$lang.delete}</a>
        </td>
    </tr>
    {foreachelse}
    <tr>
        <td colspan="7">{$lang.nothing}</td>
    </tr>
    {/foreach}
</table>
